-- Drop the problematic recursive policy
DROP POLICY IF EXISTS "Admins can view admin users" ON public.admin_users;

-- Create a simpler policy that checks auth.uid() directly against user_id
-- This avoids recursion by not doing a subquery on the same table
CREATE POLICY "Users can view their own admin record"
ON public.admin_users
FOR SELECT
USING (auth.uid() = user_id);