'use client';

import { Header } from '@/components/layout/Header';
import { Footer } from '@/components/layout/Footer';
import { Button } from '@/components/ui/button';
import Link from 'next/link';
import { ArrowLeft } from 'lucide-react';
import type { StaticImageData } from 'next/image';

interface ServiceItem {
  title: string;
  description: string;
  image: StaticImageData | string;
}

interface ServiceDetailPageProps {
  title: string;
  heroImage: StaticImageData | string;
  services: ServiceItem[];
}

export function ServiceDetailPage({ title, heroImage, services }: ServiceDetailPageProps) {
  return (
    <div className="min-h-screen">
      <Header />
      
      <main>
        {/* Hero Section */}
        <section className="pt-32 pb-16 bg-primary">
          <div className="container-custom">
            <div className="text-center max-w-3xl mx-auto">
              <span className="text-secondary font-semibold text-sm uppercase tracking-wider">
                Our Services
              </span>
              <h1 className="font-display text-4xl md:text-5xl lg:text-6xl font-bold text-primary-foreground mt-4 mb-6">
                {title}
              </h1>
            </div>
          </div>
        </section>

        {/* Hero Image */}
        <section className="relative">
          <div className="container-custom py-8">
            <div className="rounded-2xl overflow-hidden shadow-xl">
              <img
                src={typeof heroImage === 'string' ? heroImage : heroImage.src}
                alt={title}
                className="w-full h-64 md:h-96 object-cover"
              />
            </div>
          </div>
        </section>

        {/* Services Grid */}
        <section className="section-padding bg-background">
          <div className="container-custom">
            <div className="grid md:grid-cols-2 lg:grid-cols-3 gap-8">
              {services.map((service, index) => (
                <div
                  key={service.title}
                  className="group bg-card rounded-2xl overflow-hidden shadow-sm hover:shadow-xl transition-all duration-300 border border-border"
                >
                  <div className="relative h-56 overflow-hidden">
                    <img
                      src={typeof service.image === 'string' ? service.image : service.image.src}
                      alt={service.title}
                      className="w-full h-full object-cover transition-transform duration-500 group-hover:scale-110"
                    />
                  </div>
                  <div className="p-6">
                    <h3 className="font-display text-xl font-semibold text-foreground mb-3">
                      {service.title}
                    </h3>
                    <p className="text-muted-foreground text-sm leading-relaxed">
                      {service.description}
                    </p>
                  </div>
                </div>
              ))}
            </div>

            {/* Back to Services */}
            <div className="mt-12 text-center">
              <Link
                href="/services"
                className="inline-flex items-center gap-2 text-primary hover:text-primary/80 font-semibold transition-colors"
              >
                <ArrowLeft className="h-4 w-4" />
                Back to Services
              </Link>
            </div>
          </div>
        </section>

        {/* CTA Section */}
        <section className="py-16 bg-muted">
          <div className="container-custom">
            <div className="bg-card rounded-2xl p-8 md:p-12 shadow-lg">
              <div className="grid lg:grid-cols-2 gap-8 items-center">
                <div>
                  <h2 className="font-display text-2xl md:text-3xl font-bold text-foreground mb-4">
                    Let Us Help Your Loved Ones Feel at Home.
                  </h2>
                  <p className="text-muted-foreground">
                    We understand the importance of creating a supportive and caring environment for your loved ones. Let us provide the comfort and attention they deserve to feel safe and valued every day.
                  </p>
                </div>
                <div className="flex justify-center lg:justify-end">
                  <Button variant="cta" size="xl" asChild>
                    <Link href="/contact">Contact Us</Link>
                  </Button>
                </div>
              </div>
            </div>
          </div>
        </section>
      </main>

      <Footer />
    </div>
  );
}
