import { CheckCircle, Shield, Users, Heart, Star } from 'lucide-react';
import type { StaticImageData } from 'next/image';
import heroNurse from '@/assets/images/homenursingpage.avif';

const features = [
  {
    icon: Shield,
    title: 'Expert Caregivers, Steadfast Companions',
    description: "Skilled and board-certified medical professionals with genuine empathy offering high-quality care alongside the reliable, human presence of a dedicated health partner.",
  },
  {
    icon: CheckCircle,
    title: 'Affordable and Transparent Pricing',
    description: 'Accessible and high-quality care with clear, upfront pricing and absolutely no hidden fees, focusing on recovery and peace of mind.',
  },
  {
    icon: Users,
    title: 'A Legacy of Trust',
    description: 'A nationwide reputation of a dependable anchor in the lives of our patients, delivering exceptional service that you can count on every single day.',
  },
  {
    icon: Heart,
    title: 'Unwavering Support for Families',
    description: 'During challenging times, we serve as a constant source of strength and guidance to the patient and their family, alleviating the burden of care so you can focus on spending quality time with your loved ones.',
  },
];

export const WhyChooseUsSection = () => {
  return (
    <section className="section-padding bg-background">
      <div className="container-custom">
        <div className="grid lg:grid-cols-2 gap-16 items-center">
          {/* Content */}
          <div>
            <span className="text-secondary font-semibold text-sm uppercase tracking-wider">
              Why Choose Us
            </span>
            <h2 className="font-display text-3xl md:text-4xl font-bold text-foreground mt-4 mb-6">
              Your Dedicated Partner in Health and Companionship
            </h2>
            <p className="text-muted-foreground text-lg mb-8">
              We believe that exceptional care goes beyond medical tasks. We are dedicated to
              providing reliable home nursing services tailored to your unique needs with a focus on
              building a relationship of trust. Our goal is to deliver clinical excellence wrapped in
              attentive companionship, prioritizing your well-being, dignity, and comfort.
            </p>

            <div className="space-y-6">
              {features.map((feature, index) => (
                <div key={feature.title} className="flex gap-4">
                  <div className="flex-shrink-0 w-12 h-12 bg-accent rounded-xl flex items-center justify-center">
                    <feature.icon className="h-6 w-6 text-primary" />
                  </div>
                  <div>
                    <h3 className="font-semibold text-foreground mb-1">
                      {feature.title}
                    </h3>
                    <p className="text-muted-foreground text-sm">
                      {feature.description}
                    </p>
                  </div>
                </div>
              ))}
            </div>
          </div>

          {/* Image with Stats */}
          <div className="relative">
            <img
              src={typeof heroNurse === 'string' ? heroNurse : heroNurse.src}
              alt="Home Care"
              className="w-full h-[500px] object-cover rounded-3xl shadow-lg"
            />
            
            {/* Rating Card */}
            <div className="absolute -bottom-6 -left-6 bg-card rounded-2xl p-6 shadow-xl">
              <div className="flex items-center gap-4">
                <div className="w-16 h-16 bg-primary rounded-xl flex items-center justify-center">
                  <Star className="h-8 w-8 text-primary-foreground fill-primary-foreground" />
                </div>
                <div>
                  <div className="text-sm text-muted-foreground">Excellent Point</div>
                  <div className="font-display text-3xl font-bold text-foreground">4.7</div>
                  <div className="text-xs text-muted-foreground">Client Feedback</div>
                </div>
              </div>
            </div>

            {/* Badge */}
            <div className="absolute -top-4 -right-4 bg-secondary text-secondary-foreground px-6 py-3 rounded-full font-semibold shadow-lg">
              Top Company
            </div>
          </div>
        </div>
      </div>
    </section>
  );
};
