import { CheckCircle, Sparkles, Clock } from 'lucide-react';
import { Button } from '@/components/ui/button';
import Link from 'next/link';

const highlights = [
  {
    icon: CheckCircle,
    title: 'Comprehensive Range of Services',
    description: 'Providing all the care and attention your loved ones need.',
  },
  {
    icon: Sparkles,
    title: 'Focus on Comfort and Dignity',
    description: 'Ensuring respect and dignity for every individual.',
  },
  {
    icon: Clock,
    title: 'Flexible Scheduling Options',
    description: 'Care designed around your schedule and needs.',
  },
];

export const TrustedCompanySection = () => {
  return (
    <section className="section-padding bg-background">
      <div className="container-custom">
        <div className="text-center max-w-3xl mx-auto mb-12">
          <span className="text-secondary font-semibold text-sm uppercase tracking-wider">
            A TRUSTED & RELIABLE COMPANION
          </span>
          <h2 className="font-display text-3xl md:text-4xl font-bold text-foreground mt-4 mb-6">
            Discover the Heart of Aheri Care
          </h2>
          <p className="text-muted-foreground text-lg">
            At Aheri Care, we specialize in providing compassionate, professional, and reliable home
            nursing services that are deeply rooted in <strong>attentive companionship</strong>. Whether you or
            your loved ones need specialized medical attention or consistent everyday support, our
            expert team is committed to being a <strong>constant source of strength and comfort</strong>. By
            blending clinical excellence with steadfast support, we serve as a dedicated partner,
            ensuring that you never have to navigate your health journey alone - providing dignity
            and peace of mind right in the comfort of your home
          </p>
        </div>

        <div className="grid md:grid-cols-3 gap-8 mb-12">
          {highlights.map((item) => (
            <div
              key={item.title}
              className="text-center p-6 rounded-2xl bg-accent/30"
            >
              <div className="w-16 h-16 bg-primary/10 rounded-full flex items-center justify-center mx-auto mb-4">
                <item.icon className="h-8 w-8 text-primary" />
              </div>
              <h3 className="font-display text-lg font-semibold text-foreground mb-2">
                {item.title}
              </h3>
              <p className="text-muted-foreground text-sm">
                {item.description}
              </p>
            </div>
          ))}
        </div>

        <div className="text-center">
          <Button variant="cta" size="lg" asChild>
            <Link href="/services">Discover More</Link>
          </Button>
        </div>
      </div>
    </section>
  );
};
