import { Star, Quote } from 'lucide-react';

const testimonials = [
  {
    name: 'Eugene Sudi',
    role: 'Family Member',
    content: 'The care and attention provided by Aheri Care has been exceptional. Our mother receives the best treatment, and the nurses are always professional and compassionate.',
    rating: 5,
  },
  {
    name: 'Grace Wanjiku',
    role: 'Client',
    content: 'I highly recommend Aheri Care for their outstanding home nursing services. The team goes above and beyond to ensure patient comfort and dignity.',
    rating: 5,
  },
  {
    name: 'Peter Otieno',
    role: 'Family Member',
    content: 'Professional, reliable, and caring - that is how I would describe Aheri Care. They have made a significant difference in our father\'s recovery journey.',
    rating: 5,
  },
];

export const TestimonialsSection = () => {
  return (
    <section className="section-padding bg-muted">
      <div className="container-custom">
        <div className="text-center mb-12">
          <span className="text-secondary font-semibold text-sm uppercase tracking-wider">
            What Our Clients Say
          </span>
          <h2 className="font-display text-3xl md:text-4xl font-bold text-foreground mt-4">
            Testimonials from Our Clients
          </h2>
        </div>

        <div className="grid md:grid-cols-2 lg:grid-cols-3 gap-8">
          {testimonials.map((testimonial, index) => (
            <div
              key={testimonial.name}
              className="bg-card rounded-2xl p-8 shadow-sm hover:shadow-lg transition-shadow duration-300 relative"
            >
              <Quote className="absolute top-6 right-6 h-8 w-8 text-primary/10" />
              
              <div className="flex gap-1 mb-4">
                {[...Array(testimonial.rating)].map((_, i) => (
                  <Star
                    key={i}
                    className="h-5 w-5 text-secondary fill-secondary"
                  />
                ))}
              </div>
              
              <p className="text-muted-foreground mb-6 leading-relaxed">
                "{testimonial.content}"
              </p>
              
              <div className="flex items-center gap-4">
                <div className="w-12 h-12 bg-primary rounded-full flex items-center justify-center text-primary-foreground font-semibold">
                  {testimonial.name.charAt(0)}
                </div>
                <div>
                  <div className="font-semibold text-foreground">
                    {testimonial.name}
                  </div>
                  <div className="text-muted-foreground text-sm">
                    {testimonial.role}
                  </div>
                </div>
              </div>
            </div>
          ))}
        </div>
      </div>
    </section>
  );
};
