import Link from 'next/link';
import { ArrowRight } from 'lucide-react';
import { Button } from '@/components/ui/button';
import type { StaticImageData } from 'next/image';
import drugInfusion from '@/assets/images/ug-infuse.avif';
import woundCare from '@/assets/images/wound.webp';
import earSyringing from '@/assets/images/Ear Syringing.jpg';
import catheterCare from '@/assets/images/Cathetercare picture.jpg';
import stomaCare from '@/assets/images/Stoma Care.jpg';
import nebulization from '@/assets/images/nebulization.avif';

const services = [
  {
    image: drugInfusion,
    title: 'Drug Infusion Therapy',
    description: 'Experience seamless and safe drug infusion services administered by highly trained nurses.',
    tags: ['Assistance', 'Mobility'],
  },
  {
    image: woundCare,
    title: 'Advanced Wound Care',
    description: 'Our skilled nurses provide personalized wound care using advanced techniques to promote healing.',
    tags: ['Assistance', 'Mobility'],
  },
  {
    image: earSyringing,
    title: 'Ear Syringing',
    description: 'Relieve discomfort and improve hearing with safe and effective ear wax removal services.',
    tags: ['Assistance', 'Mobility'],
  },
  {
    image: catheterCare,
    title: 'Catheter Care',
    description: 'Comprehensive catheter management ensuring hygiene, comfort, and reduced infection risks.',
    tags: ['Assistance', 'Mobility'],
  },
  {
    image: stomaCare,
    title: 'Stoma Care',
    description: 'Personalized stoma care and education to help clients maintain comfort and confidence.',
    tags: ['Assistance', 'Mobility'],
  },
  {
    image: nebulization,
    title: 'Nebulization Therapy',
    description: 'Safe nebulization therapy for conditions like asthma, COPD, with nurse guidance and monitoring.',
    tags: ['Assistance', 'Mobility'],
  },
];

export const ServicesSection = () => {
  return (
    <section className="section-padding bg-muted">
      <div className="container-custom">
        {/* Header */}
        <div className="text-center max-w-3xl mx-auto mb-16">
          <span className="text-secondary font-semibold text-sm uppercase tracking-wider">
            What We Offer
          </span>
          <h2 className="font-display text-3xl md:text-4xl lg:text-5xl font-bold text-foreground mt-4 mb-6">
            Our Professional Nursing Services
          </h2>
          <p className="text-muted-foreground text-lg">
            Delivering exceptional home healthcare with compassion and expertise
          </p>
        </div>

        {/* Services Grid */}
        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
          {services.map((service, index) => (
            <div
              key={service.title}
              className="group glass-effect rounded-2xl overflow-hidden card-hover border border-white/20"
              style={{ animationDelay: `${index * 0.1}s` }}
            >
              <div className="relative h-56 overflow-hidden">
                <img
                  src={typeof service.image === 'string' ? service.image : service.image.src}
                  alt={service.title}
                  className="w-full h-full object-cover transition-transform duration-500 group-hover:scale-110"
                />
                <div className="absolute inset-0 bg-gradient-to-t from-foreground/60 to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-300" />
              </div>
              <div className="p-6">
                <h3 className="font-display text-xl font-semibold text-foreground mb-3">
                  {service.title}
                </h3>
                <p className="text-muted-foreground text-sm mb-4 leading-relaxed">
                  {service.description}
                </p>
                <div className="flex items-center justify-between">
                  <div className="flex gap-2">
                    {service.tags.map((tag) => (
                      <span
                        key={tag}
                        className="text-xs px-3 py-1 bg-accent text-accent-foreground rounded-full"
                      >
                        {tag}
                      </span>
                    ))}
                  </div>
                  <Link
                    href="/services"
                    className="text-primary font-semibold text-sm flex items-center gap-1 hover:gap-2 transition-all"
                  >
                    Learn More <ArrowRight className="h-4 w-4" />
                  </Link>
                </div>
              </div>
            </div>
          ))}
        </div>

        {/* View All Button */}
        <div className="text-center mt-12">
          <Button variant="outline" size="lg" asChild>
            <Link href="/services">
              View All Services <ArrowRight className="ml-2 h-4 w-4" />
            </Link>
          </Button>
        </div>
      </div>
    </section>
  );
};
