import { Button } from '@/components/ui/button';
import { Phone } from 'lucide-react';

export const RateCardSection = () => {
  return (
    <section className="py-16 bg-primary">
      <div className="container-custom">
        <div className="flex flex-col lg:flex-row items-center justify-between gap-8">
          <div className="text-center lg:text-left">
            <h2 className="font-display text-2xl md:text-3xl font-bold text-primary-foreground mb-4">
              Aheri Care Rate Card
            </h2>
            <p className="text-primary-foreground/80 max-w-xl">
              We offer the best services at affordable rates; offering a value for your money.
            </p>
          </div>
          <Button
            variant="hero"
            size="xl"
            asChild
          >
            <a href="tel:+254742964456" className="flex items-center gap-2">
              <Phone className="h-5 w-5" />
              Enquire Now!
            </a>
          </Button>
        </div>
      </div>
    </section>
  );
};
