import { Syringe, Bandage, Activity } from 'lucide-react';

const procedureCategories = [
  {
    icon: Syringe,
    title: 'IV Procedures',
    items: ['IV Fluid Infusion', 'IV Drug Administration', 'Vitamin Infusion Package', 'Iron Infusion Package', 'Blood Sample Collection'],
  },
  {
    icon: Bandage,
    title: 'Wound Care & Catheterization',
    items: ['Wound Care', 'Stoma Care', 'Enema', 'Catheterization', 'Flatus tube Insertion'],
  },
  {
    icon: Activity,
    title: 'Others',
    items: ['Nebulization', 'Ear Syringing/Irrigation', 'Naso-gastric tube insertion', 'Vital observation monitoring'],
  },
];

export const ProceduresSection = () => {
  return (
    <section className="section-padding bg-muted">
      <div className="container-custom">
        <div className="grid md:grid-cols-3 gap-8">
          {procedureCategories.map((category, index) => (
            <div
              key={category.title}
              className="bg-card rounded-2xl p-8 shadow-sm hover:shadow-lg transition-shadow duration-300"
            >
              <div className="w-14 h-14 bg-primary/10 rounded-xl flex items-center justify-center mb-6">
                <category.icon className="h-7 w-7 text-primary" />
              </div>
              <h3 className="font-display text-xl font-semibold text-foreground mb-4">
                {category.title}
              </h3>
              <ul className="space-y-3">
                {category.items.map((item) => (
                  <li
                    key={item}
                    className="text-muted-foreground text-sm flex items-center gap-2"
                  >
                    <div className="w-1.5 h-1.5 bg-secondary rounded-full flex-shrink-0" />
                    {item}
                  </li>
                ))}
              </ul>
            </div>
          ))}
        </div>
      </div>
    </section>
  );
};
