'use client';

import { Stethoscope, Heart, Home, Baby, CheckCircle, BookOpen } from 'lucide-react';
import Image from 'next/image';
import profNurseImg from '@/assets/images/prof-nurse.jpg';
import elderlyImg from '@/assets/images/oldcare.jpeg';
import liveInImg from '@/assets/images/live-in.jpg';
import motherBabyImg from '@/assets/images/slider3.jpeg';
import motherBabyImg2 from '@/assets/latching.jpg';

const coreServices = [
  {
    icon: Stethoscope,
    title: 'Professional Home Nursing',
    subtitle: 'Clinical Care',
    image: profNurseImg,
    color: 'bg-primary',
    description: 'Our Registered and Board-licensed nurses provide high-level clinical care right in the comfort of your home. As a reliable health partner, we manage complex medical needs while ensuring the patient feels safe and supported at home.',
    scopeOfCare: [
      'Drug administration (oral and IV/injections)',
      'Wound dressing',
      'Stoma care',
      'Catheter management',
      'Nebulization',
      'Other specialized nursing procedures'
    ],
    flexibility: 'Tailored to your specific schedule, available in 12-hour or 24-hour shifts.',
  },
  {
    icon: Heart,
    title: 'Elderly Care',
    subtitle: 'Assisted Living Support',
    image: elderlyImg,
    color: 'bg-secondary',
    description: 'We provide compassionate, personalized care designed to enhance the well-being and dignity of our seniors. Our experienced caregivers do more than just complete tasks; they serve as steadfast companions, supporting daily activities while fostering a warm, respectful environment.',
    scopeOfCare: [
      'Feeding assistance',
      'Bathing and personal hygiene',
      'Toileting',
      'Mobility support',
      'Dementia Care'
    ],
    goal: 'To ensure comfort and maintain the highest quality of life at home.',
  },
  {
    icon: Home,
    title: 'Live-In Care Services',
    subtitle: 'Round-the-Clock Support',
    image: liveInImg,
    color: 'bg-[#7C3AED]',
    description: 'For those requiring continuous support, our professionals live with the patient to provide round-the-clock attention. This service offers the ultimate peace of mind, blending essential care with the comfort of a consistent, familiar face in the home.',
    target: 'Ideal for both seniors and patients recovering from medical procedures.',
    scopeOfCare: [
      'Continuous medical monitoring',
      'Assistance with daily living',
      'Dedicated companionship to prevent isolation'
    ],
  },
];

const motherNewbornCare = {
  icon: Baby,
  title: 'Mother & Newborn Care',
  subtitle: 'Your Partner in New Life',
  image: motherBabyImg2,
  color: 'bg-[#EC4899]',
  description: 'We offer dedicated support to help mothers and newborns adjust to life together with ease and confidence. Our goal is to "mother the mother," managing the burden of care so you can focus on bonding and recovery.',
  scopeOfCare: [
    'Hygiene management',
    'Cord and skin care',
    'Feeding and latching support',
    'Health monitoring for mom and baby',
    'Fatigue control'
  ],
  education: 'Empowering moms with knowledge on specific newborn care needs.',
  packages: [
    { name: 'Daycare Service', desc: 'Daytime support for routine and rest.' },
    { name: 'Overnight Care', desc: 'Ensuring you get the sleep you need.' },
    { name: '24-Hour Service', desc: 'Full-time support.' },
    { name: 'Respite Package', desc: 'Exceptional time-off care, allowing moms to recharge.' },
  ],
};

export const CoreServicesSection = () => {
  return (
    <section className="section-padding bg-background">
      <div className="container-custom">
        {/* Header */}
        <div className="text-center mb-12">
          <span className="inline-block px-4 py-1.5 bg-muted text-muted-foreground rounded-full text-sm font-medium mb-4">
            What We Offer
          </span>
          <h2 className="font-display text-3xl md:text-4xl lg:text-5xl font-bold text-foreground mb-4">
            Core Services
          </h2>
          <p className="text-muted-foreground max-w-2xl mx-auto">
            Comprehensive healthcare solutions delivered with compassion and expertise
          </p>
        </div>

        {/* First 3 Services - 3 Column Grid */}
        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8 mb-12">
          {coreServices.map((service) => (
            <div key={service.title} className="group bg-card rounded-2xl overflow-hidden shadow-lg hover:shadow-2xl transition-shadow duration-300 p-6">
              {/* Image with overlay title */}
              <div className="relative h-48 w-full overflow-hidden rounded-2xl mb-4">
                <Image
                  src={service.image}
                  alt={service.title}
                  fill
                  className="object-cover group-hover:scale-105 transition-transform duration-500"
                />
                <div className="absolute inset-0 bg-gradient-to-t from-black/70 via-black/20 to-transparent" />
                <div className="absolute bottom-4 left-4 right-4">
                  <div className="flex items-center gap-2 mb-1">
                    <service.icon className="h-4 w-4 text-white" />
                    <h3 className="font-display text-lg font-bold text-white">
                      {service.title}
                    </h3>
                  </div>
                  <span className={`inline-block px-2 py-0.5 ${service.color} text-white text-xs font-medium rounded`}>
                    {service.subtitle}
                  </span>
                </div>
              </div>

              {/* Description */}
              <p className="text-muted-foreground text-sm leading-relaxed mb-4">
                {service.description}
              </p>

              {/* Target callout for Live-In Care */}
              {service.target && (
                <div className="mb-4 p-3 bg-[#7C3AED]/10 rounded-lg border-l-4 border-[#7C3AED]">
                  <div className="flex items-start gap-2">
                    <CheckCircle className="h-4 w-4 text-[#7C3AED] mt-0.5 flex-shrink-0" />
                    <p className="text-sm text-foreground">
                      {service.target}
                    </p>
                  </div>
                </div>
              )}

              {/* Scope of Care */}
              <div>
                <h4 className="text-xs font-semibold text-foreground mb-2 uppercase tracking-wider">
                  Scope of Care
                </h4>
                <ul className="space-y-1.5">
                  {service.scopeOfCare.map((item, i) => (
                    <li key={i} className="flex items-start gap-2 text-sm text-muted-foreground">
                      <span className="w-1 h-1 rounded-full bg-foreground mt-2 flex-shrink-0" />
                      {item}
                    </li>
                  ))}
                </ul>
              </div>

              {/* Flexibility */}
              {service.flexibility && (
                <div className="mt-4 p-3 bg-primary/5 rounded-lg border-l-4 border-primary">
                  <p className="text-sm text-foreground">
                    <span className="font-semibold">Flexibility:</span> {service.flexibility}
                  </p>
                </div>
              )}

              {/* Goal */}
              {service.goal && (
                <div className="mt-4 p-3 bg-secondary/10 rounded-lg border-l-4 border-secondary">
                  <p className="text-sm text-foreground">
                    <span className="font-semibold">Goal:</span> {service.goal}
                  </p>
                </div>
              )}
            </div>
          ))}
        </div>

        {/* Mother & Newborn Care - Full Width */}
        <div className="grid grid-cols-1 lg:grid-cols-3 gap-8 items-start">
          {/* Image Column */}
          <div className="relative h-64 lg:h-80 w-full overflow-hidden rounded-2xl">
            <Image
              src={motherNewbornCare.image}
              alt={motherNewbornCare.title}
              fill
              className="object-cover"
            />
            <div className="absolute inset-0 bg-gradient-to-t from-black/70 via-black/20 to-transparent" />
            <div className="absolute bottom-4 left-4 right-4">
              <div className="flex items-center gap-2 mb-1">
                <Baby className="h-4 w-4 text-white" />
                <h3 className="font-display text-lg font-bold text-white">
                  {motherNewbornCare.title}
                </h3>
              </div>
              <span className={`inline-block px-2 py-0.5 ${motherNewbornCare.color} text-white text-xs font-medium rounded`}>
                {motherNewbornCare.subtitle}
              </span>
            </div>
          </div>

          {/* Content Columns */}
          <div className="lg:col-span-2 grid grid-cols-1 md:grid-cols-2 gap-8">
            {/* Left Content */}
            <div>
              <p className="text-muted-foreground text-sm leading-relaxed mb-4">
                {motherNewbornCare.description}
              </p>

              {/* Scope of Care */}
              <div className="mb-4">
                <h4 className="text-xs font-semibold text-foreground mb-2 uppercase tracking-wider">
                  Scope of Care
                </h4>
                <ul className="space-y-1.5">
                  {motherNewbornCare.scopeOfCare.map((item, i) => (
                    <li key={i} className="flex items-start gap-2 text-sm text-muted-foreground">
                      <span className="w-1 h-1 rounded-full bg-foreground mt-2 flex-shrink-0" />
                      {item}
                    </li>
                  ))}
                </ul>
              </div>

              {/* Education */}
              <div className="p-3 bg-[#EC4899]/10 rounded-lg border-l-4 border-[#EC4899]">
                <div className="flex items-start gap-2">
                  <BookOpen className="h-4 w-4 text-[#EC4899] mt-0.5 flex-shrink-0" />
                  <p className="text-sm text-foreground">
                    <span className="font-semibold">Education:</span> {motherNewbornCare.education}
                  </p>
                </div>
              </div>
            </div>

            {/* Right Content - Packages */}
            <div>
              <h4 className="text-xs font-semibold text-foreground mb-3 uppercase tracking-wider">
                Flexible Packages
              </h4>
              <div className="grid grid-cols-2 gap-3">
                {motherNewbornCare.packages.map((pkg, i) => (
                  <div key={i} className="p-3 bg-muted/50 rounded-lg border border-border/50">
                    <p className="text-sm font-semibold text-foreground mb-1">{pkg.name}</p>
                    <p className="text-xs text-muted-foreground">{pkg.desc}</p>
                  </div>
                ))}
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
};
