import { Button } from '@/components/ui/button';
import { MessageCircle } from 'lucide-react';

export const ConsultationSection = () => {
  return (
    <section className="py-16 bg-secondary">
      <div className="container-custom">
        <div className="flex flex-col lg:flex-row items-center justify-between gap-8">
          <div className="text-center lg:text-left">
            <h2 className="font-display text-2xl md:text-3xl font-bold text-secondary-foreground mb-4">
              Schedule a Free Consultation and Discover Personalized Care!
            </h2>
            <p className="text-secondary-foreground/80 max-w-2xl">
              Discover compassionate care tailored to meet your unique needs. Our team is dedicated to ensuring your comfort, independence, and well-being every step of the way.
            </p>
          </div>
          <div className="flex-shrink-0">
            <Button
              variant="default"
              size="xl"
              className="bg-primary hover:bg-primary/90"
              asChild
            >
              <a href="https://wa.me/254742964456?text=Hi%2C%20I%20would%20like%20to%20get%20a%20quote%20for%20your%20services" className="flex items-center gap-2" target="_blank" rel="noopener noreferrer">
                <MessageCircle className="h-5 w-5" />
                Get a Quote
              </a>
            </Button>
          </div>
        </div>
      </div>
    </section>
  );
};
