import { Button } from '@/components/ui/button';
import Link from 'next/link';
import type { StaticImageData } from 'next/image';
import elderlyWoman from '@/assets/images/old.avif';
import elderlyMan from '@/assets/images/elderlyman.avif';

export const CTASection = () => {
  return (
    <section className="section-padding bg-primary text-primary-foreground overflow-hidden">
      <div className="container-custom">
        <div className="grid lg:grid-cols-2 gap-12 items-center">
          {/* Content */}
          <div className="order-2 lg:order-1">
            <h2 className="font-display text-3xl md:text-4xl lg:text-5xl font-bold mb-6 leading-tight">
              Let Us Help Your Loved Ones Feel at Home.
            </h2>
            <p className="text-primary-foreground/80 text-lg mb-8 leading-relaxed">
              We understand the importance of creating a supportive and caring environment for your loved ones. Let us provide the comfort and attention they deserve to feel safe and valued every day.
            </p>
            <Button variant="hero" size="xl" asChild>
              <Link href="/contact">Contact Us</Link>
            </Button>
          </div>

          {/* Images */}
          <div className="order-1 lg:order-2 relative">
            <div className="grid grid-cols-2 gap-4">
              <div className="space-y-4">
                <img
                  src={typeof elderlyWoman === 'string' ? elderlyWoman : elderlyWoman.src}
                  alt="Elderly care woman"
                  className="w-full h-64 object-cover rounded-2xl shadow-lg"
                />
              </div>
              <div className="space-y-4 pt-8">
                <img
                  src={typeof elderlyMan === 'string' ? elderlyMan : elderlyMan.src}
                  alt="Elderly care man"
                  className="w-full h-64 object-cover rounded-2xl shadow-lg"
                />
              </div>
            </div>
            {/* Decorative Element */}
            <div className="absolute -bottom-4 -right-4 w-32 h-32 bg-secondary/30 rounded-full blur-2xl" />
          </div>
        </div>
      </div>
    </section>
  );
};
