'use client';

import { useState } from 'react';
import { Button } from '@/components/ui/button';
import { Calendar, ChevronDown } from 'lucide-react';

const services = [
  'Home Nursing Care',
  'Home IV/IM Drug Infusion Therapy',
  'Advanced Wound Care',
  'Ambulance Service',
  'Live-In/Elderly Care',
  'Other',
];

export const BookingWidget = () => {
  const [selectedService, setSelectedService] = useState('');
  const [isOpen, setIsOpen] = useState(false);

  const handleBooking = () => {
    if (selectedService) {
      const message = `Hello, I would like to book an appointment for: *${selectedService}*`;
      const encodedMessage = encodeURIComponent(message);
      const whatsappNumber = '254742964456';
      const whatsappUrl = `https://wa.me/${whatsappNumber}?text=${encodedMessage}`;
      window.open(whatsappUrl, '_blank');
    }
  };

  return (
    <div className="glass-effect rounded-2xl shadow-2xl p-6 md:p-8 border border-white/20">
      <div className="flex items-center gap-3 mb-6">
        <div className="w-12 h-12 bg-primary rounded-xl flex items-center justify-center">
          <Calendar className="h-6 w-6 text-primary-foreground" />
        </div>
        <h3 className="font-display text-xl font-semibold text-foreground">
          Book an Appointment
        </h3>
      </div>

      <div className="space-y-4">
        {/* Service Selector */}
        <div className="relative">
          <button
            type="button"
            onClick={() => setIsOpen(!isOpen)}
            className="w-full p-4 bg-muted rounded-lg text-left flex items-center justify-between hover:bg-accent transition-colors"
          >
            <span className={selectedService ? 'text-foreground' : 'text-muted-foreground'}>
              {selectedService || 'Select a Service'}
            </span>
            <ChevronDown className={`h-5 w-5 transition-transform ${isOpen ? 'rotate-180' : ''}`} />
          </button>
          
          {isOpen && (
            <div className="absolute top-full left-0 right-0 mt-2 bg-card rounded-lg shadow-lg border border-border z-10 overflow-hidden">
              {services.map((service) => (
                <button
                  key={service}
                  type="button"
                  onClick={() => {
                    setSelectedService(service);
                    setIsOpen(false);
                  }}
                  className="w-full p-4 text-left hover:bg-accent transition-colors text-foreground"
                >
                  {service}
                </button>
              ))}
            </div>
          )}
        </div>

        {/* Book Button */}
        <Button
          variant="cta"
          size="lg"
          className="w-full"
          onClick={handleBooking}
          disabled={!selectedService}
        >
          Book Now!
        </Button>
      </div>
    </div>
  );
};
