import { Heart, Home, Clock, Activity } from 'lucide-react';

const additionalServices = [
  {
    icon: Heart,
    title: 'Elderly Care',
    description: 'Compassionate assistance with daily activities, mobility support, and companionship to enhance seniors\' independence.',
  },
  {
    icon: Home,
    title: 'Live-In Services',
    description: 'Round-the-clock care with a live-in nurse for comprehensive, uninterrupted support.',
  },
  {
    icon: Activity,
    title: 'Ambulance Services',
    description: 'Rapid and reliable emergency transport with professional medical staff, equipped with state-of-the-art life-saving equipment for immediate care during transit.',
  },
  {
    icon: Clock,
    title: 'Physiotherapy Services',
    description: 'Personalized rehabilitation programs focusing on mobility improvement, pain relief, and recovery after injury or surgery, to restore functionality and enhance quality of life.',
  },
];

export const AdditionalServicesSection = () => {
  return (
    <section className="section-padding bg-background">
      <div className="container-custom">
        <div className="text-center mb-12">
          <h2 className="font-display text-3xl md:text-4xl font-bold text-foreground mb-4">
            Additional Services
          </h2>
          <p className="text-muted-foreground max-w-2xl mx-auto">
            Comprehensive care solutions to meet all your healthcare needs
          </p>
        </div>

        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
          {additionalServices.map((service, index) => (
            <div
              key={service.title}
              className="group p-8 rounded-2xl bg-accent/50 hover:bg-primary hover:text-primary-foreground transition-all duration-300 card-hover"
            >
              <div className="mb-6">
                <div className="w-16 h-16 rounded-xl bg-secondary/20 group-hover:bg-primary-foreground/20 flex items-center justify-center transition-colors">
                  <service.icon className="h-8 w-8 text-secondary group-hover:text-primary-foreground transition-colors" />
                </div>
              </div>
              <h3 className="font-display text-xl font-semibold mb-3">{service.title}</h3>
              <p className="text-sm leading-relaxed opacity-80">{service.description}</p>
            </div>
          ))}
        </div>
      </div>
    </section>
  );
};
