import { Eye, Target } from 'lucide-react';
import { Button } from '@/components/ui/button';
import Link from 'next/link';

export const AboutSection = () => {
  return (
    <section className="section-padding bg-muted">
      <div className="container-custom">
        <div className="grid lg:grid-cols-2 gap-16 items-center">
          {/* Content */}
          <div>
            <span className="text-secondary font-semibold text-sm uppercase tracking-wider">
              Who We Are
            </span>
            <h2 className="font-display text-3xl md:text-4xl font-bold text-foreground mt-4 mb-6">
              Dedicated to Providing Care with Dignity and Respect.
            </h2>
            <p className="text-muted-foreground text-lg mb-8 leading-relaxed">
              Providing compassionate care for the elderly is essential for enhancing their quality of life. Building meaningful connections, offering emotional support, and addressing their unique health needs create an environment where they feel valued and respected. With personalized attention and a focus on their well-being, we can help them live with dignity and independence.
            </p>

            <div className="grid sm:grid-cols-2 gap-6 mb-8">
              {/* Vision */}
              <div className="p-6 bg-card rounded-xl shadow-sm">
                <div className="w-12 h-12 bg-primary/10 rounded-lg flex items-center justify-center mb-4">
                  <Eye className="h-6 w-6 text-primary" />
                </div>
                <h3 className="font-display text-lg font-semibold text-foreground mb-2">
                  Our Vision
                </h3>
                <p className="text-muted-foreground text-sm">
                  To be a premier centre of holistic care for wholesome wellness.
                </p>
              </div>

              {/* Mission */}
              <div className="p-6 bg-card rounded-xl shadow-sm">
                <div className="w-12 h-12 bg-secondary/10 rounded-lg flex items-center justify-center mb-4">
                  <Target className="h-6 w-6 text-secondary" />
                </div>
                <h3 className="font-display text-lg font-semibold text-foreground mb-2">
                  Our Mission
                </h3>
                <p className="text-muted-foreground text-sm">
                  To inspire hope and contribute to health and well-being by providing exceptional care in an atmosphere of trust, safety, and comfort.
                </p>
              </div>
            </div>

            <Button variant="outline" size="lg" asChild>
              <Link href="/services">Learn More</Link>
            </Button>
          </div>

          {/* Stats */}
          <div className="relative">
            <div className="bg-card rounded-3xl p-8 shadow-lg">
              <span className="text-secondary font-semibold text-sm uppercase tracking-wider">
                About Us
              </span>
              <h3 className="font-display text-2xl md:text-3xl font-bold text-foreground mt-4 mb-6">
                Building Trust, One Family at a Time
              </h3>
              <p className="text-muted-foreground mb-8">
                Our team of compassionate and qualified nurses is dedicated to providing exceptional care that promotes healing, independence, and dignity. We work closely with you and your doctor to develop a personalized care plan that addresses your specific medical conditions and recovery goals.
              </p>

              <div className="grid grid-cols-3 gap-4">
                <div className="text-center p-4 bg-accent rounded-xl">
                  <div className="font-display text-3xl md:text-4xl font-bold text-primary">
                    829
                  </div>
                  <div className="text-muted-foreground text-sm mt-1">
                    Satisfied Clients
                  </div>
                </div>
                <div className="text-center p-4 bg-accent rounded-xl">
                  <div className="font-display text-3xl md:text-4xl font-bold text-primary">
                    45
                  </div>
                  <div className="text-muted-foreground text-sm mt-1">
                    Our Team
                  </div>
                </div>
                <div className="text-center p-4 bg-accent rounded-xl">
                  <div className="font-display text-3xl md:text-4xl font-bold text-primary">
                    8
                  </div>
                  <div className="text-muted-foreground text-sm mt-1">
                    Years of Service
                  </div>
                </div>
              </div>
            </div>

            {/* Decorative */}
            <div className="absolute -top-6 -right-6 w-24 h-24 bg-secondary/20 rounded-full blur-xl" />
            <div className="absolute -bottom-6 -left-6 w-32 h-32 bg-primary/10 rounded-full blur-xl" />
          </div>
        </div>
      </div>
    </section>
  );
};
