import Script from 'next/script'

export function StructuredData() {
  const structuredData = {
    '@context': 'https://schema.org',
    '@type': 'MedicalBusiness',
    name: 'Ahericare',
    description: 'Professional home nursing and healthcare services in Nairobi, Kenya',
    url: 'https://ahericare.com',
    telephone: '+254742964456',
    address: {
      '@type': 'PostalAddress',
      streetAddress: 'Westlands',
      addressLocality: 'Nairobi',
      addressCountry: 'KE'
    },
    geo: {
      '@type': 'GeoCoordinates',
      latitude: -1.2635,
      longitude: 36.8025
    },
    openingHoursSpecification: {
      '@type': 'OpeningHoursSpecification',
      dayOfWeek: [
        'Monday',
        'Tuesday',
        'Wednesday',
        'Thursday',
        'Friday',
        'Saturday',
        'Sunday'
      ],
      opens: '00:00',
      closes: '23:59'
    },
    priceRange: '$$',
    areaServed: {
      '@type': 'City',
      name: 'Nairobi'
    },
    hasOfferCatalog: {
      '@type': 'OfferCatalog',
      name: 'Home Nursing Services',
      itemListElement: [
        {
          '@type': 'Offer',
          itemOffered: {
            '@type': 'Service',
            name: 'Home Nursing Services',
            description: 'Professional nursing care at home'
          }
        },
        {
          '@type': 'Offer',
          itemOffered: {
            '@type': 'Service',
            name: 'IV Therapy',
            description: 'Drug infusion and IV therapy at home'
          }
        },
        {
          '@type': 'Offer',
          itemOffered: {
            '@type': 'Service',
            name: 'Wound Care',
            description: 'Advanced wound care services'
          }
        },
        {
          '@type': 'Offer',
          itemOffered: {
            '@type': 'Service',
            name: 'Elderly Care',
            description: 'Compassionate elderly care services'
          }
        }
      ]
    }
  }

  const breadcrumbList = {
    '@context': 'https://schema.org',
    '@type': 'BreadcrumbList',
    itemListElement: [
      {
        '@type': 'ListItem',
        position: 1,
        name: 'Home',
        item: 'https://ahericare.com'
      },
      {
        '@type': 'ListItem',
        position: 2,
        name: 'Services',
        item: 'https://ahericare.com/services'
      },
      {
        '@type': 'ListItem',
        position: 3,
        name: 'Contact',
        item: 'https://ahericare.com/contact'
      }
    ]
  }

  return (
    <>
      <Script
        id="structured-data-organization"
        type="application/ld+json"
        dangerouslySetInnerHTML={{ __html: JSON.stringify(structuredData) }}
      />
      <Script
        id="structured-data-breadcrumb"
        type="application/ld+json"
        dangerouslySetInnerHTML={{ __html: JSON.stringify(breadcrumbList) }}
      />
    </>
  )
}
