'use client';

import { ServiceDetailPage } from '@/components/services/ServiceDetailPage';
import profNurse from '@/assets/images/prof-nurse.jpg';
import treat from '@/assets/images/treat.jpg';
import ugInfuse from '@/assets/images/ug-infuse.avif';
import chronic from '@/assets/images/chronic.jpg';
import nebulization from '@/assets/images/nebulization.avif';
import postSurgery from '@/assets/images/postsargery.jpg';

const services = [
  {
    title: 'Advanced Wound Care',
    description: 'Specialized management of chronic and non-healing wounds. We utilize state-of-the-art therapies to accelerate recovery, reduce infection risks, and improve patient quality of life.',
    image: treat,
  },
  {
    title: 'Drug Infusion',
    description: 'Administration of medications directly into the bloodstream through an intravenous (IV) line to ensure rapid and effective treatment for various conditions.',
    image: ugInfuse,
  },
  {
    title: 'Home Vital Observation',
    description: 'Continuous monitoring of vital signs such as blood pressure, heart rate, and temperature in the comfort of a patient\'s home, ensuring early detection of health issues.',
    image: chronic,
  },
  {
    title: 'Nebulization',
    description: 'A treatment method for respiratory conditions, using a nebulizer to deliver medication directly to the lungs for easier breathing and faster relief.',
    image: nebulization,
  },
  {
    title: 'Stoma Care',
    description: 'Specialized care and support for individuals with stomas, including guidance on hygiene, maintenance, and managing potential complications to improve quality of life.',
    image: postSurgery,
  },
];

export default function ProfessionalNursing() {
  return (
    <ServiceDetailPage
      title="Professional Nursing Services"
      heroImage={profNurse}
      services={services}
    />
  );
}
