import type { Metadata } from 'next';

export const metadata: Metadata = {
  title: 'Professional Nursing Services - Expert Medical Care at Home',
  description: 'Professional nursing services in Nairobi, Kenya: Advanced care, drug infusion, home vital observation, nebulization, and stoma care. Expert healthcare delivered at home.',
  keywords: [
    'professional nursing Nairobi',
    'advanced care Kenya',
    'drug infusion services',
    'home vital monitoring',
    'nebulization therapy',
    'stoma care Kenya',
    'medical nursing services',
    'expert nursing care',
  ],
  alternates: {
    canonical: 'https://ahericare.com/services/professional-nursing',
  },
  openGraph: {
    title: 'Professional Nursing Services | Ahericare',
    description: 'Expert professional nursing services including advanced care, drug infusion, and vital monitoring in Nairobi, Kenya.',
    url: 'https://ahericare.com/services/professional-nursing',
    type: 'website',
  },
};

export default function ProfessionalNursingLayout({
  children,
}: {
  children: React.ReactNode
}) {
  return children;
}
