'use client';

import { Header } from '@/components/layout/Header';
import { Footer } from '@/components/layout/Footer';
import { Button } from '@/components/ui/button';
import Image from 'next/image';
import Link from 'next/link';
import { ArrowRight, Stethoscope, Home, Baby, Heart } from 'lucide-react';
import drugInfusion from '@/assets/images/Drug Infusion Therapy.jpg';
import woundCare from '@/assets/images/Advanced Wound Care.jpg';
import catheterCare from '@/assets/Cathetercare picture.jpg';
import profNurseImg from '@/assets/images/prof-nurse.jpg';
import elderlyImg from '@/assets/images/oldcare.jpeg';
import liveInImg from '@/assets/images/live-in.jpg';
import motherBabyImg from '@/assets/babycare.jpg';

const coreServices = [
  {
    icon: Home,
    title: 'Home Care Services',
    image: liveInImg,
    iconBg: 'bg-secondary',
    description: 'Our home health services provide compassionate and professional care tailored to your loved one\'s needs. We offer assistance with daily activities, medical care, companion care, dimenetia care, elderly care, respite care and emotional support in the comfort of your home.',
    link: '/services/home-health',
  },
  {
    icon: Stethoscope,
    title: 'Professional Home Nursing',
    image: profNurseImg,
    iconBg: 'bg-primary',
    description: 'Our Registered and Board-licensed nurses provide high-level clinical care right in the comfort of your home. We manage complex medical needs while ensuring the patient feels safe and supported.',
    link: '/services/professional-nursing',
  },
  {
    icon: Baby,
    title: 'Mother & Newborn Care',
    image: motherBabyImg,
    iconBg: 'bg-[#EC4899]',
    description: 'We offer dedicated support to help mothers and newborns adjust to life together with ease and confidence. Our goal is to "mother the mother," managing care so you can focus on bonding and recovery.',
    link: '/services/mother-newborn-care',
  },
  {
    icon: Heart,
    title: 'Community Health Services',
    image: elderlyImg,
    iconBg: 'bg-[#7C3AED]',
    description: 'Providing essential healthcare services to communities, focusing on well-being, prevention, and health education to improve lives.',
    link: '/services/community-health',
  },
];

const nursingServices = [
  {
    title: 'Drug Infusion Therapy',
    description: 'Experience seamless and safe drug infusion services administered by highly trained nurses. Our IV procedures include IV Fluid Infusion, IV Drug Administration, Vitamin Infusion Package, Iron Infusion Package, and Blood Sample Collection.',
    image: drugInfusion,
  },
  {
    title: 'Advanced Wound Care',
    description: 'Our skilled nurses provide personalized wound care using advanced techniques to promote healing. We specialize in wound assessment, treatment planning, and ongoing care management.',
    image: woundCare,
  },
  {
    title: 'Catheter Care',
    description: 'Comprehensive catheter management ensuring hygiene, comfort, and reduced infection risks. Our trained professionals provide expert catheter insertion, maintenance, and removal services.',
    image: catheterCare,
  },
];

export default function Services() {
  return (
    <div className="min-h-screen">
      <Header />
      
      <main>
        {/* Hero Section */}
        <section className="pt-32 pb-16 bg-primary">
          <div className="container-custom">
            <div className="text-center max-w-3xl mx-auto">
              <span className="text-secondary font-semibold text-sm uppercase tracking-wider">
                What We Offer
              </span>
              <h1 className="font-display text-4xl md:text-5xl lg:text-6xl font-bold text-primary-foreground mt-4 mb-6">
                Trusted Home Health Care Services Designed for Your Family.
              </h1>
              <p className="text-primary-foreground/80 text-lg">
                Comprehensive home nursing services that prioritize your comfort, dignity, and well-being.
              </p>
            </div>
          </div>
        </section>

        {/* Main Services */}
        <section className="section-padding bg-background">
          <div className="container-custom">
            <div className="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6">
              {coreServices.map((service) => (
                <div key={service.title} className="group bg-card rounded-2xl overflow-hidden shadow-sm hover:shadow-lg transition-shadow duration-300">
                  {/* Image with icon overlay */}
                  <div className="relative h-52 w-full overflow-hidden">
                    <Image
                      src={service.image}
                      alt={service.title}
                      fill
                      className="object-cover group-hover:scale-105 transition-transform duration-500"
                    />
                    {/* Icon positioned at bottom left */}
                    <div className={`absolute bottom-4 left-4 w-12 h-12 ${service.iconBg} rounded-lg flex items-center justify-center shadow-lg`}>
                      <service.icon className="h-6 w-6 text-white" />
                    </div>
                  </div>

                  {/* Content */}
                  <div className="p-5">
                    <h3 className="font-display text-lg font-bold text-foreground mb-3">
                      {service.title}
                    </h3>
                    <p className="text-muted-foreground text-sm leading-relaxed mb-4 line-clamp-4">
                      {service.description}
                    </p>
                    <Link 
                      href={service.link}
                      className="inline-flex items-center gap-1.5 text-primary font-semibold text-sm hover:gap-2 transition-all duration-200"
                    >
                      See All Services
                      <ArrowRight className="h-4 w-4" />
                    </Link>
                  </div>
                </div>
              ))}
            </div>
          </div>
        </section>

        {/* Detailed Services */}
        <section className="section-padding bg-muted">
          <div className="container-custom">
            <div className="text-center mb-12">
              <h2 className="font-display text-3xl md:text-4xl font-bold text-foreground mb-4">
                Our Nursing Services
              </h2>
              <p className="text-muted-foreground max-w-2xl mx-auto">
                Expert medical care delivered with compassion and professionalism
              </p>
            </div>

            <div className="space-y-16">
              {nursingServices.map((service, index) => (
                <div
                  key={service.title}
                  className={`grid lg:grid-cols-2 gap-12 items-center ${
                    index % 2 === 1 ? 'lg:flex-row-reverse' : ''
                  }`}
                >
                  <div className={index % 2 === 1 ? 'lg:order-2' : ''}>
                    <img
                      src={typeof service.image === 'string' ? service.image : service.image.src}
                      alt={service.title}
                      className="w-full h-80 object-cover rounded-2xl shadow-lg"
                    />
                  </div>
                  <div className={index % 2 === 1 ? 'lg:order-1' : ''}>
                    <h3 className="font-display text-2xl md:text-3xl font-bold text-foreground mb-4">
                      {service.title}
                    </h3>
                    <p className="text-muted-foreground text-lg leading-relaxed mb-6">
                      {service.description}
                    </p>
                    <Button variant="cta" asChild>
                      <Link href="/contact">Book This Service</Link>
                    </Button>
                  </div>
                </div>
              ))}
            </div>
          </div>
        </section>

        {/* CTA */}
        <section className="py-16 bg-secondary">
          <div className="container-custom">
            <div className="flex flex-col lg:flex-row items-center justify-between gap-8">
              <div className="text-center lg:text-left">
                <h2 className="font-display text-2xl md:text-3xl font-bold text-secondary-foreground mb-4">
                  Schedule a Free Consultation and Discover Personalized Care!
                </h2>
                <p className="text-secondary-foreground/80 max-w-2xl">
                  Discover compassionate care tailored to meet your unique needs.
                </p>
              </div>
              <Button variant="default" size="xl" className="bg-primary hover:bg-primary/90" asChild>
                <a href="https://wa.me/254742964456?text=Hi%2C%20I%20would%20like%20to%20get%20a%20quote%20for%20your%20services" target="_blank" rel="noopener noreferrer">Get a Quote</a>
              </Button>
            </div>
          </div>
        </section>
      </main>
    </div>
  );
}
