'use client';

import { ServiceDetailPage } from '@/components/services/ServiceDetailPage';
import motherBabyImg from '@/assets/latching.jpg';
import nurse2Img from '@/assets/overnight.jpg';
import nurse3Img from '@/assets/24hr.jpg';
import homeImg from '@/assets/respite.jpg';
import nurseImg from '@/assets/hygiene.jpg';
import latching from '@/assets/breastfeeding.jpg'

const services = [
  {
    title: 'Daycare Service',
    description: 'Daytime support for routine and rest. Our professional caregivers provide assistance during the day so mothers can rest and recover while ensuring baby is well cared for.',
    image: motherBabyImg,
  },
  {
    title: 'Overnight Care',
    description: 'Ensuring you get the sleep you need. Our overnight care specialists take over nighttime duties, including feeding, changing, and soothing, so you can get uninterrupted rest.',
    image: nurse2Img,
  },
  {
    title: '24-Hour Service',
    description: 'Full-time support around the clock. Comprehensive care for both mother and baby with dedicated professionals available at all hours to assist with any needs.',
    image: nurse3Img,
  },
  {
    title: 'Respite Package',
    description: 'Exceptional time-off care, allowing moms to recharge or attend to other needs while we take over. Perfect for when you need a break or have appointments to attend.',
    image: homeImg,
  },
  {
    title: 'Hygiene & Cord Care',
    description: 'Expert management of newborn hygiene including bathing, cord care, and skin care. We ensure proper techniques to promote healing and prevent infection.',
    image: nurseImg,
  },
  {
    title: 'Feeding & Latching Support',
    description: 'Breastfeeding guidance and support for successful feeding journeys. Our specialists help with latching techniques, feeding schedules, and troubleshooting common challenges.',
    image: latching,
  },
];

export default function MotherNewbornCare() {
  return (
    <ServiceDetailPage
      title="Mother & Newborn Care"
      heroImage={motherBabyImg}
      services={services}
    />
  );
}
