import type { Metadata } from 'next';

export const metadata: Metadata = {
  title: 'Mother & Newborn Care Services | Aheri Care',
  description: 'Dedicated support for mothers and newborns. We offer daycare, overnight care, 24-hour service, and respite packages to help you adjust to life with your new baby.',
  keywords: ['mother care', 'newborn care', 'postpartum support', 'baby care', 'breastfeeding support', 'Uganda'],
  openGraph: {
    title: 'Mother & Newborn Care Services | Aheri Care',
    description: 'Professional mother and newborn care services including daycare, overnight care, and comprehensive postpartum support.',
    type: 'website',
  },
};

export default function MotherNewbornCareLayout({
  children,
}: {
  children: React.ReactNode;
}) {
  return children;
}
