import type { Metadata } from 'next';

export const metadata: Metadata = {
  title: 'Our Services - Home Nursing, IV Therapy & Wound Care in Nairobi',
  description: 'Comprehensive home nursing services in Nairobi, Kenya: IV therapy, drug infusion, wound care, catheter care, elderly care, and professional nursing at home. Expert healthcare services across Nairobi.',
  keywords: [
    'IV therapy Nairobi',
    'drug infusion services',
    'wound care Kenya',
    'catheter care services',
    'home nursing services',
    'elderly care Nairobi',
    'professional nursing',
    'home health services Kenya',
    'medical care at home',
  ],
  alternates: {
    canonical: 'https://ahericare.com/services',
  },
  openGraph: {
    title: 'Home Nursing Services - IV Therapy, Wound Care | Ahericare',
    description: 'Expert home nursing services including IV therapy, wound care, and catheter care in Nairobi, Kenya.',
    url: 'https://ahericare.com/services',
    type: 'website',
  },
};

export default function ServicesLayout({
  children,
}: {
  children: React.ReactNode
}) {
  return children;
}
