'use client';

import { ServiceDetailPage } from '@/components/services/ServiceDetailPage';
import homeNursingPage from '@/assets/images/homenursingpage.avif';
import oldCare from '@/assets/images/old.avif';
import liveIn from '@/assets/images/live-in.jpg';
import home from '@/assets/images/home.jpg';

const services = [
  {
    title: 'Elderly Care',
    description: 'Compassionate and personalized care designed to enhance the well-being and comfort of elderly individuals, supporting their daily activities and health needs.',
    image: oldCare,
  },
  {
    title: 'Live-in Services',
    description: 'Round-the-clock care provided by professional nurses who live with the patient to offer continuous medical attention, companionship, and assistance with daily living.',
    image: liveIn,
  },
  {
    title: '12/24hr Home Nursing Services',
    description: 'Flexible home nursing care available 12 or 24 hours a day, tailored to meet the specific medical and personal needs of patients at home.',
    image: home,
  },
];

export default function HomeHealthServices() {
  return (
    <ServiceDetailPage
      title="Home Health Services"
      heroImage={homeNursingPage}
      services={services}
    />
  );
}
