import type { Metadata } from 'next';

export const metadata: Metadata = {
  title: 'Home Health Services - Elderly Care & Live-in Nursing',
  description: 'Home health services in Nairobi, Kenya: Elderly care, live-in nursing services, and 12/24hr home nursing care. Compassionate healthcare delivered at home.',
  keywords: [
    'home health services Nairobi',
    'elderly care Kenya',
    'live-in nursing services',
    '24 hour nursing care',
    'home nursing Nairobi',
    'elderly home care',
    'senior care services',
    'home healthcare Kenya',
  ],
  alternates: {
    canonical: 'https://ahericare.com/services/home-health',
  },
  openGraph: {
    title: 'Home Health Services | Ahericare',
    description: 'Expert home health services including elderly care and live-in nursing in Nairobi, Kenya.',
    url: 'https://ahericare.com/services/home-health',
    type: 'website',
  },
};

export default function HomeHealthLayout({
  children,
}: {
  children: React.ReactNode
}) {
  return children;
}
