'use client';

import { ServiceDetailPage } from '@/components/services/ServiceDetailPage';
import communityPage from '@/assets/images/community-page.jpg';
import camp from '@/assets/images/camp.jpg';
import camp2 from '@/assets/images/camp2.jpg';
import comm2 from '@/assets/images/comm2.jpg';

const services = [
  {
    title: 'Medical Camps',
    description: 'Temporary healthcare facilities offering free or low-cost medical services, including screenings, consultations, and treatments to underserved communities.',
    image: camp,
  },
  {
    title: 'Corporate CSR Program',
    description: 'Corporate initiatives aimed at supporting community health and well-being, aligning business objectives with social responsibility through contributions and volunteer efforts.',
    image: camp2,
  },
  {
    title: 'Community Health Sensitization & Education Programs',
    description: 'Programs focused on raising awareness and educating communities about health issues, preventive care, and wellness practices to improve public health outcomes.',
    image: comm2,
  },
];

export default function CommunityHealthServices() {
  return (
    <ServiceDetailPage
      title="Community Health Services"
      heroImage={communityPage}
      services={services}
    />
  );
}
