import type { Metadata } from 'next';

export const metadata: Metadata = {
  title: 'Community Health Services - Medical Camps & CSR Programs',
  description: 'Community health services in Nairobi, Kenya: Medical camps, corporate CSR programs, and health education initiatives. Supporting community well-being.',
  keywords: [
    'community health services Nairobi',
    'medical camps Kenya',
    'corporate CSR healthcare',
    'health education programs',
    'community wellness Kenya',
    'public health services',
    'health sensitization',
    'community healthcare Nairobi',
  ],
  alternates: {
    canonical: 'https://ahericare.com/services/community-health',
  },
  openGraph: {
    title: 'Community Health Services | Ahericare',
    description: 'Community health services including medical camps and CSR programs in Nairobi, Kenya.',
    url: 'https://ahericare.com/services/community-health',
    type: 'website',
  },
};

export default function CommunityHealthLayout({
  children,
}: {
  children: React.ReactNode
}) {
  return children;
}
