import type { Metadata } from 'next';

export const metadata: Metadata = {
  title: 'Home Nursing & Healthcare Services in Nairobi, Kenya',
  description: 'Professional home nursing and healthcare services in Nairobi, Kenya. Expert home care, IV therapy, wound care, catheter care, elderly care, and 24/7 nursing services. Serving Westlands, Nairobi and across Kenya.',
  keywords: [
    'home nursing Nairobi',
    'home care Kenya',
    'home health services Nairobi',
    'professional nursing Kenya',
    'IV therapy home',
    'wound care Nairobi',
    'elderly care services',
    'home healthcare Nairobi',
  ],
  alternates: {
    canonical: 'https://ahericare.com',
  },
  openGraph: {
    title: 'Ahericare - Professional Home Nursing Services in Nairobi',
    description: 'Expert home nursing, IV therapy, wound care, and elderly care services in Nairobi, Kenya. Available 24/7.',
    url: 'https://ahericare.com',
    type: 'website',
    images: [
      {
        url: 'https://ahericare.com/og-image.jpg',
        width: 1200,
        height: 630,
        alt: 'Ahericare Home Nursing Services',
      },
    ],
  },
};

import { HeroSection } from '@/components/home/HeroSection';
import { AdditionalServicesSection } from '@/components/home/AdditionalServicesSection';
import { CTASection } from '@/components/home/CTASection';
import { AboutSection } from '@/components/home/AboutSection';
import { CoreServicesSection } from '@/components/home/CoreServicesSection';
import { ConsultationSection } from '@/components/home/ConsultationSection';    
import { ProceduresSection } from '@/components/home/ProceduresSection';
import { TrustedCompanySection } from '@/components/home/TrustedCompanySection';
import { WhyChooseUsSection } from '@/components/home/WhyChooseUsSection';
import { RateCardSection } from '@/components/home/RateCardSection';
import { TestimonialsSection } from '@/components/home/TestimonialsSection';
import { BookingWidget } from '@/components/home/BookingWidget';

export default function Home() {
  return (
    <main>
      {/* Hero with Booking Widget */}
      <div className="relative">
        <HeroSection />
          
          {/* Floating Booking Widget */}
          <div className="hidden lg:block absolute bottom-0 right-8 translate-y-1/2 z-20 w-96">
            <BookingWidget />
          </div>
        </div>

        {/* Mobile Booking Widget */}
        <div className="lg:hidden container-custom -mt-8 relative z-10 pb-8">
          <BookingWidget />
        </div>

        <WhyChooseUsSection />
        <CTASection />
        <TrustedCompanySection />
        <AboutSection />
        <CoreServicesSection />
        <AdditionalServicesSection />
        <ConsultationSection />
        <ProceduresSection />
        <RateCardSection />
        <TestimonialsSection />
      </main>
  );
}
