import type { Metadata } from 'next';
import Link from 'next/link';
import { Home } from 'lucide-react';

export const metadata: Metadata = {
  title: 'Page Not Found',
  description: 'The page you are looking for could not be found. Return to Ahericare home page for professional home nursing and healthcare services in Nairobi, Kenya.',
  robots: {
    index: false,
    follow: false,
  },
};

export default function NotFound() {
  return (
    <div className="min-h-screen flex items-center justify-center bg-background">
      <div className="text-center px-4">
        <h1 className="font-display text-9xl font-bold text-primary mb-4">404</h1>
        <h2 className="font-display text-3xl md:text-4xl font-bold text-foreground mb-4">
          Page Not Found
        </h2>
        <p className="text-muted-foreground text-lg mb-8 max-w-md mx-auto">
          Sorry, we couldn't find the page you're looking for. The page may have been moved or deleted.
        </p>
        <Link 
          href="/"
          className="inline-flex items-center justify-center gap-2 rounded-md bg-secondary px-8 py-4 text-sm font-semibold text-secondary-foreground shadow hover:bg-secondary/90 transition-colors"
        >
          <Home className="h-4 w-4" />
          Back to Home
        </Link>
      </div>
    </div>
  );
}
