import type { Metadata } from 'next';

export const metadata: Metadata = {
  title: 'Gallery - Our Home Nursing & Healthcare Services',
  description: 'View our professional home nursing and healthcare services in action. See how we provide compassionate care, IV therapy, wound care, and elderly care services in Nairobi, Kenya.',
  keywords: [
    'home nursing photos',
    'healthcare services Nairobi',
    'nursing care gallery',
    'home care Kenya',
  ],
  alternates: {
    canonical: 'https://ahericare.com/gallery',
  },
  openGraph: {
    title: 'Gallery - Ahericare Home Nursing Services',
    description: 'See our professional home nursing and healthcare services in Nairobi, Kenya.',
    url: 'https://ahericare.com/gallery',
    type: 'website',
  },
};

export default function GalleryLayout({
  children,
}: {
  children: React.ReactNode
}) {
  return children;
}
