import type { Metadata } from 'next';

export const metadata: Metadata = {
  title: 'Contact Us - Home Nursing Services in Nairobi, Kenya',
  description: 'Contact Ahericare for professional home nursing and healthcare services in Nairobi, Kenya. Call +254 742 964 456 for 24/7 home care, IV therapy, wound care, and elderly care services. Located in Westlands, Nairobi.',
  keywords: [
    'contact home nursing Nairobi',
    'home care contact Kenya',
    'nursing services Westlands',
    'healthcare Nairobi contact',
    '24/7 home nursing',
  ],
  alternates: {
    canonical: 'https://ahericare.com/contact',
  },
  openGraph: {
    title: 'Contact Ahericare - Home Nursing Services Nairobi',
    description: 'Get in touch for professional home nursing and healthcare services in Nairobi, Kenya. Available 24/7.',
    url: 'https://ahericare.com/contact',
    type: 'website',
  },
};

export default function ContactLayout({
  children,
}: {
  children: React.ReactNode
}) {
  return children;
}
