# Ahericare - Next.js Application

This application has been successfully migrated from Vite + React to Next.js 15.

## Migration Summary

### What Changed

1. **Framework**: Migrated from Vite to Next.js 15 with App Router
2. **Routing**: Replaced React Router with Next.js file-based routing
3. **Project Structure**: 
   - Moved pages from `src/pages/` to `src/app/` directory
   - Created Next.js layouts and page components
   - Removed Vite-specific files (vite.config.ts, index.html, etc.)

4. **Configuration Files**:
   - Created `next.config.js` for Next.js configuration
   - Updated `tsconfig.json` for Next.js TypeScript support
   - Converted `postcss.config.js` to CommonJS format
   - Updated `.eslintrc.json` to use Next.js ESLint config

5. **Dependencies**:
   - Added Next.js 15 and related packages
   - Removed Vite and React Router dependencies
   - Kept all UI components and libraries (Radix UI, Tailwind, etc.)

6. **Component Updates**:
   - Added `'use client'` directive to interactive components
   - Updated all `Link` components from React Router to Next.js
   - Changed `to` props to `href` props
   - Replaced `useLocation` with `usePathname`
   - Fixed image imports to work with Next.js StaticImageData type

### File Structure

```
src/
├── app/
│   ├── layout.tsx           # Root layout with providers
│   ├── page.tsx             # Home page
│   ├── not-found.tsx        # 404 page
│   ├── providers.tsx        # React Query provider
│   ├── client-providers.tsx # Client-side providers
│   ├── globals.css          # Global styles
│   ├── contact/
│   │   └── page.tsx
│   ├── gallery/
│   │   └── page.tsx
│   └── services/
│       └── page.tsx
├── components/
│   ├── home/                # Home page sections
│   ├── layout/              # Header & Footer
│   └── ui/                  # Shadcn UI components
├── hooks/
├── lib/
└── assets/
```

## Getting Started

### Development

```bash
npm run dev
```

Open [http://localhost:3000](http://localhost:3000) in your browser.

### Build

```bash
npm run build
```

### Production

```bash
npm run start
```

### Linting

```bash
npm run lint
```

## Key Features

- ✅ Next.js 15 with App Router
- ✅ TypeScript support
- ✅ Tailwind CSS styling
- ✅ Shadcn UI components
- ✅ React Query for data fetching
- ✅ Responsive design
- ✅ SEO-friendly with metadata API
- ✅ Fast page loads with static generation

## Routes

- `/` - Home page
- `/services` - Services listing
- `/gallery` - Image gallery
- `/contact` - Contact form
- `/*` - 404 not found page

## Notes

- All pages are pre-rendered as static content for optimal performance
- Client components are marked with `'use client'` directive
- Images use Next.js StaticImageData type for type safety
- Toast notifications use Sonner library
- React Query is configured in client-side provider

## Migration Tips

If you need to add new pages:
1. Create a new directory in `src/app/` 
2. Add a `page.tsx` file with your component
3. Export default function from the page component
4. Use `'use client'` if the component needs interactivity

For client-side navigation:
```tsx
import Link from 'next/link';

<Link href="/your-path">Link Text</Link>
```

For programmatic navigation:
```tsx
'use client';
import { useRouter } from 'next/navigation';

const router = useRouter();
router.push('/your-path');
```
